#!/bin/bash
#***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
#***********************************************************************************************************

set -euo pipefail

export SF_ORIGINAL_EXE="$0"

HELPER_EXEC="$(readlink -ev "$0")"
HELPER_DIR="$(dirname "${HELPER_EXEC}")"
PACKAGE="$(basename "${HELPER_DIR}")"
# the script is symlinked and $0 points to the symlink name, not the script name
EXEC_BASENAME="$(basename "${0}")"
readonly HELPER_EXEC HELPER_DIR PACKAGE EXEC_BASENAME
if [[ "${EXEC_BASENAME}" = "sf" ]]; then
    # special case for sfclient (STAR-2411)
    readonly EXEC_NAME="client"
else
    # links in /usr/bin are prefixed with sf
    readonly EXEC_NAME="${EXEC_BASENAME#sf}"
fi

if [[ -z "${SFHOME:-""}" ]]; then
    SFHOME="$(readlink -ev "${HELPER_DIR}/../..")"
    export SFHOME
fi

if [[ -d "${SFHOME}/tmp" ]]; then
    export TMPDIR="${SFHOME}/tmp"
fi

export PYTHONUTF8=1

exec "${SFHOME}/lib312/${PACKAGE}/_sf${EXEC_NAME}/_sf${EXEC_NAME}" "$@"
