# ***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
# ***********************************************************************************************************
"""
    Add tables for permission model
"""
from pathlib import Path

import sqlparse
from alembic import op
from jinja2 import Template

# revision identifiers, used by Alembic.
revision = "0161"
down_revision = "0160"
branch_labels = None
depends_on = None


def upgrade():
    with open(Path(__file__).parent / f"{revision}-tables.sql") as f:
        sql_stmts = f.read()
    op.execute(sqlparse.format(sql_stmts, strip_comments=True))

    with open(Path(__file__).parent / f"{revision}-custom-zone-role-triggers.sql") as f:
        sql_stmts = f.read()
    op.execute(sqlparse.format(sql_stmts, strip_comments=True))

    with open(Path(__file__).parent / f"{revision}-wildcard-constraint-triggers.j2.sql") as f:
        trigger_stmts = f.read()

    trigger_params = [
        {
            "subject_table": "resource",
            "subject_id_column": "unique_id",
            "association_table": "resource_in_zone_v2",
            "wildcard_switch_column": "is_available_in_all_zones",
            "object": "zone",
        },
        {
            "subject_table": "default_zone_role",
            "subject_id_column": "id",
            "association_table": "default_zone_role_zone_v2",
            "wildcard_switch_column": "is_available_in_all_zones",
            "object": "zone",
        },
        {
            "subject_table": "custom_zone_role_capability",
            "subject_id_column": "id",
            "association_table": "custom_zone_role_capability_resource",
            "wildcard_switch_column": "is_available_for_all_zone_resources",
            "object": "resource",
        },
    ]

    for params in trigger_params:
        # Names of created triggers and functions to make it easy to find a migration that added them:
        # Triggers:
        #  resource_cannot_have_specific_zones_if_is_available_in_all_zones
        #  insert_cannot_add_zone_to_resource_if_is_available_in_all_zones
        #  update_cannot_add_zone_to_resource_if_is_available_in_all_zones
        #  default_zone_role_cannot_have_specific_zones_if_is_available_in_all_zones
        #  insert_cannot_add_zone_to_default_zone_role_if_is_available_in_all_zones
        #  update_cannot_add_zone_to_default_zone_role_if_is_available_in_all_zones
        #  custom_zone_role_capability_cannot_have_specific_resources_if_is_available_for_all_zone_resources
        #  insert_cannot_add_resource_to_custom_zone_role_capability_if_is_available_for_all_zone_resources
        #  update_cannot_add_resource_to_custom_zone_role_capability_if_is_available_for_all_zone_resources
        # Functions:
        #  check_is_available_for_all_zone_resources_when_adding_resource_to_custom_zone_role_capability
        #  check_is_available_in_all_zones_when_adding_zone_to_default_zone
        #  check_is_available_in_all_zones_when_adding_zone_to_resource
        #  check_no_rows_in_custom_zone_role_capability_resource_for_modified_row
        #  check_no_rows_in_default_zone_role_zone_v2_for_modified_row
        #  check_no_rows_in_resource_in_zone_v2_for_modified_row
        op.execute(sqlparse.format(Template(trigger_stmts).render(params), strip_comments=True))
