/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

ALTER TABLE sf.dir_metadata
    RENAME TO tmp;
ALTER TABLE sf.tmp
    DROP CONSTRAINT scan_metadata_pk;
ALTER TABLE sf.tmp
    DROP CONSTRAINT dir_metadata_dir_id_unq;


CREATE TABLE sf.dir_metadata (LIKE sf.tmp INCLUDING ALL)
PARTITION BY HASH (volume_id partition_custom_bigint_hash_op);

ALTER TABLE sf.dir_metadata
    ADD CONSTRAINT dir_metadata_pk PRIMARY KEY (id, volume_id);
ALTER TABLE sf.dir_metadata
    ADD CONSTRAINT dir_metadata_dir_id_unq UNIQUE (dir_id, volume_id);

CREATE OR REPLACE FUNCTION __partition_dir_metadata(
) RETURNS VOID AS $$
DECLARE
    partition_id BIGINT;
BEGIN
    FOR partition_id IN
        select split_part(tablename, '_', 4) from pg_tables where tablename ~ '^dir_current_part_\d+$'
    LOOP
        execute format('CREATE TABLE sf.dir_metadata_part_%s PARTITION OF sf.dir_metadata FOR VALUES WITH (MODULUS 500, REMAINDER %s)', partition_id, partition_id);
        execute format('ALTER TABLE sf.dir_metadata_part_%s ADD CONSTRAINT dir_metadata_volume_id_fk FOREIGN KEY (volume_id, dir_id) REFERENCES sf.dir_current_part_%s(volume_id, id) ON DELETE CASCADE', partition_id, partition_id);
    END LOOP;
END;
$$ LANGUAGE plpgsql SECURITY DEFINER VOLATILE PARALLEL UNSAFE;

select __partition_dir_metadata();

INSERT INTO sf.dir_metadata SELECT * FROM sf.tmp;

DROP TABLE sf.tmp;
