/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

/*******************************************************************************************************************************
    Setting redash user permissions
*******************************************************************************************************************************/

DO
$body$
DECLARE
    schemas text;
    username text := 'reports_user';
BEGIN
    -- The user is added by post-install scripts thus he is not present when the code is run in tests
    -- other than those that use Starfish installed from packages.
    IF EXISTS (SELECT * FROM pg_catalog.pg_user WHERE usename = username) THEN
        SELECT string_agg(schema_name, ', ')
        FROM information_schema.schemata
        WHERE
            (schema_name LIKE 'sf_%' OR schema_name in ('sf', 'public'))
            AND NOT schema_name = 'sf_reports'
        INTO schemas;

        EXECUTE 'GRANT USAGE ON SCHEMA ' || schemas || ' TO ' || username;
        EXECUTE 'GRANT SELECT ON ALL TABLES IN SCHEMA ' || schemas || ' TO ' || username;
        -- Make all new (not existing now) tables accessible by the user when they are created.
        -- It works only for tables created by starfish user.
        EXECUTE 'ALTER DEFAULT PRIVILEGES IN SCHEMA ' || schemas || ' GRANT SELECT ON TABLES TO ' || username;
    END IF;
END
$body$
LANGUAGE 'plpgsql';
