# ***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
# ***********************************************************************************************************
"""
   Update zone manager role name
"""

from alembic import op

# Renames Zone Managers role names, so they include `zone.id` instead of the `zone.name`
# as zone can be renamed.
# The previous migration was missing role names where corresponding zone has been renamed, for
# example, before STAR-8714 users has made following operations
#     1. user creates zone "new_zone" (i.e. id=777, name="new_zone")
#         -> corresponding role is created (i.e. id=777, name="zone-new_zone-managers")
#     2. user renames zone to "another_zone" (i.e. id=777, name="another_zone") -> corresponding role name remains
#        the same  (i.e. id=777, name="zone-new_zone-managers")
#
#     Previous migration fails to rename role id=777, as there is no "zone-another_zone-managers" role name.
#
# This one is one handles the above case.

# revision identifiers, used by Alembic.
revision = "0123"
down_revision = "0122"
branch_labels = None
depends_on = None


def upgrade():
    op.execute(
        """
        UPDATE sf_auth.role r
        SET "name" = 'zone-' || a.value || '-managers'
        FROM sf_auth.role_ability  ra,  sf_auth.ability a
        WHERE r.id = ra.role_id
        AND ra.ability_id = a.id
        AND a.method = 'manage-files' -- it is ZoneNeedMethod.MANAGE_FILES
        AND a.type = 'zone'
        """
    )
