/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
-- similar to:
 -- tag_aging_redash_query.sql
 -- zone_tag_aging_redash_query.sql
-- whenever someone changes this file changing the ones above should also be considered

SELECT sf_auth.zone.name,
       atime_age,
       mtime_age,
       ROUND(SUM(size) / (1024 * 1024 * 1024.0), 2) AS "logical size (GiB)",
       ROUND(SUM(physical_size) / (1024 * 1024 * 1024.0), 2) AS "physical size (GiB)",
       SUM(count) AS count,
       SUM(cost) AS cost,
       run_time
FROM sf_reports.tags_current
    JOIN sf_auth.zone ON SUBSTRING(tags_current.tag, length('__zone:')+1) = zone.id::VARCHAR
WHERE  SUBSTRING(tags_current.tag, 1, length('__zone:')) = '__zone:'
GROUP BY sf_auth.zone.name,
         atime_age,
         mtime_age,
         run_time
ORDER BY atime_age,
         mtime_age
