/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
WITH dirs_with_dirs_only AS (
    SELECT d.path,
           CASE
               WHEN d.depth <=1 THEN ''
               WHEN d.depth > 1 THEN LEFT(d.path, -LENGTH(d.name) - 1)
           END AS parent_path,
           (d.rec_aggrs->>'dirs')::BIGINT - 1  AS dirs_underneath
    FROM sf.dir_current d
    WHERE (d.rec_aggrs->>'dirs')::BIGINT > 1
        AND (d.rec_aggrs->>'files')::BIGINT = 0
        AND d.volume_id = sf.volume_id_from_name('{{volume}}')
)
SELECT dir.path,
       dir.dirs_underneath AS "dirs"
FROM dirs_with_dirs_only AS dir
LEFT JOIN dirs_with_dirs_only AS parent ON parent.path = dir.parent_path
WHERE parent IS NULL
    AND dir.dirs_underneath >= {{min_number_of_dirs_inside}}
ORDER BY dir.dirs_underneath DESC
LIMIT {{number_of_rows}}
