/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
SELECT
    '/'||dir.path as "path",
    COALESCE(u.name, dir.uid::text) AS "owner",
    ROUND((COALESCE(rec_aggrs->>'blocks_div_nlinks', rec_aggrs->>'blocks')::BIGINT * 512)::DECIMAL / (1024 * 1024 * 1024.0), 2) AS "physical size (GiB)",
    ROUND((dir.rec_aggrs->>'size')::DECIMAL / (1024 * 1024 * 1024.0), 2) AS "logical size (GiB)",
    (dir.rec_aggrs->>'files')::BIGINT as "file count",
    (dir.rec_aggrs->>'dirs')::BIGINT as "subdirectory count"
FROM sf.dir_current dir
LEFT JOIN sf.uid_mapping u ON dir.uid = u.uid
    AND dir.volume_id = u.volume_id
WHERE dir.volume_id = sf.volume_id_from_name('{{volume}}')
  AND depth <= {{max_depth}}
  AND (dir.rec_aggrs->>'size')::DECIMAL >= {{min_size_GB}}::DECIMAL * (1024 * 1024 * 1024.0)
ORDER BY "physical size (GiB)" DESC
LIMIT {{number_of_rows}}
