/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT run_time,
       mtime_age,
       SUM(physical_size) / (1024 * 1024 * 1024.0) AS "physical size",
       SUM(count) AS "files",
       SUM(cost) AS "cost"
FROM sf_reports.last_time_generic_history
WHERE volume_name = '{{volume}}'
    AND run_time >= (now() - interval '{{number_of_days_to_look_back}} days')
GROUP BY mtime_age, run_time
ORDER BY run_time, mtime_age
