/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
WITH large_dirs AS (
    SELECT dir.volume_id,
          dir.path,
          (dir.rec_aggrs->>'size')::DECIMAL AS logical_size,
          (COALESCE(dir.rec_aggrs->>'blocks_div_nlinks', dir.rec_aggrs->>'blocks')::BIGINT * 512)::DECIMAL AS physical_size,
          (dir.rec_aggrs->>'files')::BIGINT AS file_count,
          (dir.rec_aggrs->>'dirs')::BIGINT AS subdir_count,
          dir.depth,
          dir.id AS id,
          dir.parent_id AS parent_id,
          dir.uid
   FROM sf.dir_current dir
   INNER JOIN sf.dir_current parent_dir ON dir.parent_id = parent_dir.id
   WHERE dir.depth BETWEEN 3 AND 5
     AND ((dir.rec_aggrs->>'size')::DECIMAL) >= ((parent_dir.rec_aggrs->>'size')::DECIMAL * 0.7)
     AND (dir.rec_aggrs->>'size')::DECIMAL >= {{min_size_GB}}*(1024.0*1024*1024)
)
SELECT COALESCE(vol.display_name, vol.name) AS volume,
       dir.path,
       COALESCE(uid_map.name, dir.uid::text) AS username,
       ROUND(dir.logical_size/(1024.0*1024*1024), 2) AS "logical size (GiB)",
       ROUND(dir.physical_size/(1024.0*1024*1024), 2) AS "physical size (GiB)",
       dir.FILE_COUNT AS "file count",
       dir.SUBDIR_COUNT AS "subdirectory count"
FROM large_dirs dir
INNER JOIN sf_volumes.volume vol ON dir.volume_id = vol.id
LEFT JOIN sf.uid_mapping uid_map ON dir.uid = uid_map.uid AND dir.volume_id = uid_map.volume_id
LEFT JOIN large_dirs child_dir ON dir.id = child_dir.parent_id
WHERE child_dir.parent_id IS NULL  -- choose the deepest dir possible (so if you have both /root/a and /root/a/b in large_dirs table choose /root/a/b only)
ORDER BY dir.logical_size DESC,
         volume,
         dir.path
LIMIT {{number_of_rows}}
