/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
CREATE TEMPORARY TABLE resolved_uid ON COMMIT DROP AS (
    SELECT DISTINCT
        u.volume_id,
        v.name AS volume_name,
        u.uid
    FROM sf.uid_mapping u
    INNER JOIN sf_volumes.volume v ON v.id = u.volume_id
    WHERE
        u.name = '{{username}}' OR u.uid::TEXT = '{{username}}'
);
CREATE INDEX resolved_uid_idx ON resolved_uid (uid, volume_id);
ANALYZE resolved_uid;

SELECT
    volume,
    path,
    ROUND(size_GiB, 2) AS size_GiB
FROM (
    SELECT
        v.name AS volume,
        d.path,
        (d.local_aggrs->'total'->>'size')::BIGINT / (1024.0 * 1024 * 1024) AS size_GiB
    FROM sf.dir_current AS d
    INNER JOIN resolved_uid AS u ON d.uid = u.uid AND u.volume_id = d.volume_id
    INNER JOIN sf_volumes.volume AS v ON d.volume_id = v.id

    UNION ALL

    SELECT
        'All volumes' AS volume,
        'All files owned by user' AS path,
        SUM(size) / (1024.0 * 1024 * 1024) AS size_GiB
    FROM sf_reports.last_time_generic_current AS ltgc
    INNER JOIN resolved_uid u ON ltgc.uid = u.uid AND ltgc.volume_name = u.volume_name

    UNION ALL

    SELECT
        'All volumes' AS volume,
        'All dirs owned by user' AS path,
        SUM((d.local_aggrs->'total'->>'size')::BIGINT) / (1024.0 * 1024 * 1024) AS size_GiB
    FROM sf.dir_current d
    INNER JOIN resolved_uid u ON u.volume_id = d.volume_id AND u.uid = d.uid
) t
ORDER by size_GiB DESC
LIMIT 1000
