/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
WITH query AS (
SELECT
    mtime_age,
    physical_size_bucket,
    ROUND(SUM(physical_size) / (1024 * 1024 * 1024.0), 2) AS physical_size_GiB
FROM sf_reports.last_time_generic_current
GROUP BY mtime_age, physical_size_bucket
)
-- THIS IS HACK - Adding column with hidden HTML with number
-- Combined with "sort by X values" in redash forces correct column order on chart
SELECT *,
    '<b style="display: none !important" class="hidden">'
        || LPAD((DENSE_RANK() OVER(ORDER BY sf.physical_size_bucket_to_lower_limit(physical_size_bucket) ASC))::TEXT, 3, '0')
        || '</b>'
        || physical_size_bucket AS ordered_physical_size_bucket_html
FROM query
