/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

 SELECT
    to_char(SUM("volume occupied space") * 100 / SUM("total capacity"), '990D9%') AS "Used %",
    to_char(SUM((u.value::NUMERIC * "volume occupied space"::NUMERIC) / (1000 * 1000 * 1000.0)), '$999G999G999') AS "Cost",
    to_char(SUM((u.value::NUMERIC * "volume free space") / (1000 * 1000 * 1000.0)), '$999G999G999') AS "Cost of Unused Space",
    to_char(SUM("total capacity"::NUMERIC / (1024 * 1024 * 1024.0)), '999G999G999') AS "Capacity (GiB)",
    to_char(SUM("volume occupied space"::NUMERIC / (1024 * 1024 * 1024.0)), '999G999G999') AS "Used physical (GiB)",
    to_char(SUM("volume occupied space logical"::NUMERIC / (1024 * 1024 * 1024.0)), '999G999G999') AS "Used logical (GiB)",
    to_char(SUM("volume free space"::NUMERIC / (1024 * 1024 * 1024.0)), '999G999G999') AS "Free (GiB)"
FROM sf_reports.stats_current s
JOIN sf_volumes.volume v ON v.name = "volume name"
JOIN sf_volumes.user_param u ON v.id = u.volume_id
WHERE u.name = 'cost_per_gb'
