/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH ajobs AS (
    SELECT aj.id,
         at.type AS target_type,
         JSONB_ARRAY_ELEMENTS_TEXT(aj.low_level_jobs::JSONB->'UPLOADING_FILES')::BIGINT AS lluj,
         JSONB_ARRAY_ELEMENTS_TEXT(aj.low_level_jobs::JSONB->'REMOVING_SOURCE')::BIGINT AS llrj
    FROM sf_archive.archive_job aj
    INNER JOIN sf_archive.archive_target at ON aj.target_id = at.id
    WHERE aj.creation_time >= NOW() - INTERVAL '{{number_of_days_to_look_back}} day'
),
archived_and_removed AS (
    SELECT
        SUM((sji.fs_stats->>'fs_bytes_done')::NUMERIC) AS size,
        SUM((sji.fs_stats->>'fs_entries_done')::BIGINT)::BIGINT AS entries
    FROM sf_dispatcher.incarnation sji
    INNER JOIN ajobs ON ajobs.llrj = sji.job_id
    WHERE sji.created_at >= NOW() - INTERVAL '{{number_of_days_to_look_back}} day'
),
totals AS (
    SELECT
        ajobs.target_type,
        SUM((sji.fs_stats->>'fs_bytes_done')::NUMERIC) AS size,
        SUM((sji.fs_stats->>'fs_entries_done')::BIGINT)::BIGINT AS entries
    FROM sf_dispatcher.incarnation sji
    INNER JOIN ajobs ON ajobs.lluj = sji.job_id
    WHERE sji.created_at >= NOW() - INTERVAL '{{number_of_days_to_look_back}} day'
    GROUP BY target_type
),
removed AS (
    SELECT SUM((i.fs_stats->>'fs_bytes_done')::NUMERIC) AS size
    FROM sf_dispatcher.job AS j LEFT JOIN sf_dispatcher.incarnation AS i ON j.id = i.job_id WHERE j.command->>0 = 'remove'
    AND i.created_at >= NOW() - INTERVAL '{{number_of_days_to_look_back}} day'
),
copy_jobs AS (
    SELECT SUM((i.fs_stats->>'fs_bytes_done')::NUMERIC) AS size
    FROM sf_dispatcher.job AS j
    LEFT JOIN sf_dispatcher.incarnation AS i ON j.id = i.job_id
    LEFT JOIN sf.job_name AS jn ON jn.id = j.name_id
    WHERE (jn.name LIKE 'upload-%' OR jn.name = 'copy' OR jn.name LIKE 'rsync_wrapper-%')
    AND i.created_at >= NOW() - INTERVAL '{{number_of_days_to_look_back}} day'
),
category_size AS (
SELECT 'Removed' AS category, COALESCE((SELECT SUM(size) FROM removed), 0) AS size
UNION
SELECT 'Archived and removed (migrated)' AS category, COALESCE((SELECT SUM(size) FROM archived_and_removed), 0) AS size
UNION
SELECT 'Archived to object storage (copied)' AS category, COALESCE((SELECT SUM(size) FROM totals WHERE target_type != 'volume'), 0) AS size
UNION
SELECT 'Archived to volume (copied)' AS category, COALESCE((SELECT SUM(size) FROM totals WHERE target_type = 'volume'), 0) AS size
UNION
SELECT 'Copied' AS category, COALESCE((SELECT SUM(size) FROM copy_jobs), 0) AS size_GB
)
SELECT category, ROUND(size / (1024::BIGINT * 1024*1024),2) AS "size (GiB)", size AS "size (B)" FROM category_size;
