/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
-- TODO STAR-7464 Fix this report
SELECT COALESCE(v.display_name, v.name) as Volume,
       '<a href="queries/QUERY_ID_FOR_REPORT(top_directories_by_dir_id)?p_dir_id='|| dir.id ||'">' || dir.path || '</a>' AS directory_path,
       ROUND((dir.rec_aggrs->>'size')::DECIMAL / (1024 * 1024 * 1024.0), 2) AS "logical size (GiB)",
       ROUND((COALESCE(dir.rec_aggrs->>'blocks_div_nlinks', dir.rec_aggrs->>'blocks')::BIGINT * 512)::DECIMAL / (1024 * 1024 * 1024.0), 2) AS "physical size (GiB)",
       (dir.rec_aggrs->>'files')::BIGINT as "file count",
       (dir.rec_aggrs->>'dirs')::BIGINT as "subdirectory count"
FROM sf.dir_current dir
INNER JOIN sf_volumes.volume AS v ON dir.volume_id = v.id
WHERE dir.depth <= {{max_depth}}
  AND dir.id IN (
     SELECT zvc.fs_entry_id AS sf_tag_value_fs_entry_id
     FROM sf.tag_value_current AS zvc
     JOIN sf.tag_value_current AS tvc ON zvc.fs_entry_id = tvc.fs_entry_id
     JOIN sf.tag_name AS zn ON zn.id = zvc.name_id
     JOIN sf_auth.zone ON zn.name = zone.id::VARCHAR
     JOIN sf.tag_name AS tn ON tn.id = tvc.name_id
     WHERE zone.name = '{{{zone}}}'
     AND tn.name = '{{{tag}}}'
  )
  AND dir.inode IS NOT NULL
  AND dir.size IS NOT NULL
ORDER BY "physical size (GiB)" DESC
LIMIT {{number_of_rows}}
