/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
WITH RECURSIVE root_dir AS (
    SELECT *
        FROM sf.dir_current
        WHERE id = {{dir_id}}
), dirs AS (
    SELECT id,
           volume_id,
           path,
           uid,
           (rec_aggrs->>'size')::DECIMAL AS logical_recursive_size,
           (COALESCE(rec_aggrs->>'blocks_div_nlinks', rec_aggrs->>'blocks')::BIGINT * 512)::DECIMAL AS physical_recursive_size
    FROM root_dir

    UNION ALL

    SELECT dir_current.id,
           dir_current.volume_id,
           dir_current.path,
           dir_current.uid,
           (dir_current.rec_aggrs->>'size')::DECIMAL AS logical_recursive_size,
           (COALESCE(dir_current.rec_aggrs->>'blocks_div_nlinks', dir_current.rec_aggrs->>'blocks')::BIGINT * 512)::DECIMAL AS physical_recursive_size
    FROM sf.dir_current
        CROSS JOIN root_dir
        INNER JOIN dirs ON dirs.id = dir_current.parent_id
            AND dir_current.depth <= root_dir.depth + {{max_relative_depth}}
    WHERE (dir_current.rec_aggrs->>'size')::DECIMAL >= {{min_size_GB}}::DECIMAL * (1024 * 1024 * 1024.0)
), limited_dirs AS (
    SELECT * FROM dirs
    ORDER BY logical_recursive_size DESC
    LIMIT {{number_of_rows}}
)
SELECT COALESCE(v.display_name, v.name) AS "volume",
       dir.path AS "path",
       COALESCE(u.name, dir.uid::text) AS "owner",
       ROUND(logical_recursive_size / (1024 * 1024 * 1024.0), 2) AS "logical size (GiB)",
       ROUND(physical_recursive_size / (1024 * 1024 * 1024.0), 2) AS "physical size (GiB)"
FROM limited_dirs as dir
    INNER JOIN sf_volumes.volume AS v ON dir.volume_id = v.id
    LEFT JOIN sf.uid_mapping u ON dir.uid = u.uid
        AND v.id = u.volume_id
ORDER BY logical_recursive_size DESC
