/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH files AS (
    SELECT
        file.name AS file_name,
        file.parent_id,
        mount.path AS mount_path
    FROM sf.file_current file
    INNER JOIN sf_volumes.volume volume ON volume.id = file.volume_id
    LEFT JOIN sf_volumes.mount mount ON mount.volume_id = file.volume_id AND mount.agent = volume.default_agent_address
    WHERE ('{{volume}}' = '*' OR file.volume_id = (SELECT id FROM sf_volumes.volume WHERE name = '{{volume}}'))
          AND file.size = {{size}}
)

SELECT get_full_sys_path(file.mount_path, dir.path, file.file_name) AS path
FROM files file
LEFT JOIN sf.dir_current dir ON dir.id = file.parent_id
    AND ('{{volume}}' = '*' OR dir.volume_id = (SELECT id FROM sf_volumes.volume WHERE name = '{{volume}}'))
ORDER BY path
