/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH scans_in_progress AS (
    SELECT
        *
    FROM
        sf_scans.scan
    WHERE
        state_name='in_progress'
    ORDER BY
        heartbeat DESC
),
hours_since_last_heartbeat AS (
    SELECT
        *,
        (EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - EXTRACT(EPOCH FROM heartbeat)) / 3600 AS hours_since_heartbeat
    FROM
        scans_in_progress
)
SELECT
    vol.id AS volume_id,
    vol.name AS volume_name,
    hb.id AS scan_id,
    hb.reason,
    hb.reason_msg,
    hb.heartbeat,
    ROUND(CAST(hb.hours_since_heartbeat as numeric), 2) AS hours_since_heartbeat
FROM
    hours_since_last_heartbeat hb JOIN sf_volumes.volume vol ON (hb.volume_id=vol.id)
UNION ALL
SELECT
    NULL AS volume_id,
    NULL AS volume_name,
    NULL AS scan_id,
    NULL AS reason,
    NULL AS reason_msg,
    NULL AS heartbeat,
    0 AS hours_since_heartbeat
WHERE NOT EXISTS (SELECT 1 FROM hours_since_last_heartbeat)
ORDER BY hours_since_heartbeat DESC;
