/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT
    namespace AS schema,
    ROUND(SUM(total_relation_size) / 1024.0 / 1024 / 1024, 2)  AS "Size (GiB)",
    ROUND(SUM(total_relation_size) * 100 / MAX(database_size), 2) AS "DB usage percentage",
    run_time
FROM sf_reports.postgres_table_size_history
WHERE run_time > NOW() - INTERVAL '730 days'
GROUP BY run_time, schema
ORDER BY run_time, schema
