/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH tables AS (
    SELECT schemaname,
           tablename,
           REGEXP_REPLACE(tablename, '_part_[0-9]+', '') AS "parent_table",
           PG_TABLE_SIZE(CONCAT(schemaname, '.', tablename)) AS size,
           PG_TOTAL_RELATION_SIZE(CONCAT(schemaname, '.', tablename)) AS total_size
    FROM pg_tables
    WHERE schemaname LIKE 'sf%' AND schemaname != 'sf_internal' -- user reports_user does not have access to sf_internal
)
SELECT CONCAT(schemaname, '.', parent_table) AS "table",
       SUM(total_size) AS "total size",
       SUM(size) AS "data size",
       CASE WHEN COUNT(*) > 1 THEN 'YES' ELSE 'NO' END AS "is partitioned",
       CASE WHEN COUNT(*) > 1 THEN COUNT(*) -1 ELSE NULL END AS partitions
FROM tables
GROUP BY parent_table, schemaname
ORDER BY SUM(total_size) DESC, schemaname, parent_table
