/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */


WITH volume AS (
    SELECT id
    FROM sf_volumes.volume
    WHERE name = '{{volume}}'
    UNION
    SELECT 0
    FROM sf_volumes.volume
    WHERE '{{volume}}' = '*'
    HAVING COUNT(*) > 0
)

SELECT
    ROUND(COALESCE(SUM(size), 0) / (1024::NUMERIC * 1024 * 1024 * 1024), 2) as "logical size (TiB)",
    ROUND(COALESCE(SUM(blocks), 0) * 512 / (1024::NUMERIC * 1024 * 1024 * 1024), 2)  as "physical size (TiB)",
    COUNT(*) as count
FROM sf.file_current f
WHERE ('{{volume}}' = '*' OR volume_id = (SELECT id FROM sf_volumes.volume WHERE name = '{{volume}}'))
  AND size >= {{min_file_size_gib}} * 1024::BIGINT * 1024 * 1024
  -- 4 is a reasonable approximation.
  -- Could have been 2 or 3, but 4 vastly increases the chance that it is actually sparse (vs. compressed)
  AND size > 4 * blocks * 512
-- to not show a row when there are no volumes at all (an extreme case)
-- or in case of non-existent volume name (for example misspelling in the parameter (if a pulldown parameter would be replaced))
HAVING EXISTS(SELECT 1 FROM volume)
