/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

CREATE TEMPORARY TABLE files_in_zone_simple__zonedirs ON COMMIT DROP AS (
  SELECT
      tvc.volume_id,
      d.id AS dir_id,
      d.parent_id AS parent_id
  FROM sf.tag_value_current tvc
  INNER JOIN sf.tag_name tn ON tvc.name_id = tn.id
  INNER JOIN sf.tag_namespace space ON tn.namespace_id = space.id
  INNER JOIN sf.dir_current d ON tvc.fs_entry_id = d.id
  JOIN sf_auth.zone zname ON tn.name = zname.id::varchar
  WHERE space.name = '__zone'
    AND zname.name = '{{zone}}'
);

ANALYZE files_in_zone_simple__zonedirs;

CREATE TEMPORARY TABLE files_in_zone_simple_matches ON COMMIT DROP AS (
    SELECT UNNEST(STRING_TO_ARRAY('{{{file_name_regex}}}', '|')) AS pattern
);

ANALYZE files_in_zone_simple_matches;

WITH RECURSIVE zone_alldirs AS (
    SELECT
        zd.volume_id,
        zd.dir_id,
        zd.parent_id
    FROM files_in_zone_simple__zonedirs zd

    UNION

    SELECT
        child.volume_id,
        child.id,
        child.parent_id
    FROM sf.dir_current child
    INNER JOIN zone_alldirs parent ON parent.dir_id = child.parent_id AND child.volume_id = parent.volume_id
)

SELECT
    v.name AS volume,
    m.pattern,
    ROUND(SUM(f.size) / (1024::BIGINT * 1024 * 1024), 2) AS size_GiB,
    count(f.id) AS count
FROM zone_alldirs zd
INNER JOIN sf.file_current f ON f.parent_id = zd.dir_id AND f.volume_id = zd.volume_id
INNER JOIN sf_volumes.volume v ON v.id = zd.volume_id
INNER JOIN files_in_zone_simple_matches m ON f.name ~ m.pattern
GROUP BY v.name, m.pattern
ORDER BY volume, pattern
