/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
SELECT
    zone.name AS Zone,
    atime_age,
    SUM(ROUND(physical_size / (1024 * 1024 * 1024.0), 2)) AS "physical size (GiB)",
    ROUND(SUM(cost)::DECIMAL,0) AS "Cost"
FROM sf_reports.tags_current AS tags_current
JOIN sf_auth.zone ON tags_current.tag = '__zone:' || zone.id::VARCHAR
GROUP BY zone.name, atime_age
ORDER BY zone, atime_age
