/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

 WITH query AS (
    SELECT
        user_name AS user_name,
        atime_age AS atime,
        SUM(ROUND(physical_size / (1024 * 1024 * 1024.0), 2)) AS "Physical",
        ROUND(SUM(cost)::NUMERIC, 2) AS "Cost"
    FROM sf_reports.last_time_generic_current
    WHERE (ROUND(size / (1024 * 1024 * 1024.0), 2) > 0)
    GROUP BY atime_age, user_name
    ORDER BY SUM(physical_size) DESC, atime_age
    LIMIT 60
)
SELECT * FROM query
UNION ALL
SELECT
    NULL AS user_name,
    NULL AS atime,
    NULL AS "Physical",
    NULL AS Cost
WHERE NOT EXISTS (SELECT 1 FROM query LIMIT 1);
