/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
SELECT
    "volume name",
    SUM("volume occupied space") * 100 / SUM("total capacity") AS "used %",
    ROUND(SUM((u.value::FLOAT * "volume occupied space") / (1000 * 1000 * 1000.0))::NUMERIC, 2) AS "Cost",
    ROUND(SUM((u.value::FLOAT * "volume free space") / (1000 * 1000 * 1000.0))::NUMERIC, 2) AS "Cost of Unused Space",
    ROUND((SUM(u.value::FLOAT * "volume occupied space" + u.value::FLOAT * "volume free space") / (1000 * 1000 * 1000.0))::NUMERIC, 2) AS "Total Cost",
    SUM(ROUND("total capacity" / (1024 * 1024 * 1024.0), 2)) AS "Capacity (GiB)",
    SUM(ROUND("volume occupied space" / (1024 * 1024 * 1024.0), 2)) AS "Used physical (GiB)",
    SUM(ROUND("volume occupied space logical" / (1024 * 1024 * 1024.0), 2)) AS "Used logical (GiB)",
    SUM(ROUND("volume free space" / (1024 * 1024 * 1024.0), 2)) AS "Free (GiB)",
    SUM("regular files") AS "Regular Files",
    SUM("symbolic links") AS "Symbolic Links",
    MAX(ROUND("maximum file size" / (1024 * 1024 * 1024.0), 2)) AS "max file size (GiB)",
    SUM("directories") AS "Directories",
    SUM("directories without files") AS "directories with subdirectories only",
    SUM("empty directories") AS "Empty Directories",
    MAX(ROUND("maximum directory non-recursive size" / (1024 * 1024 * 1024.0), 2)) AS "max dir size (GiB)"
FROM sf_reports.stats_current s
JOIN sf_volumes.volume v ON v.name = "volume name"
JOIN sf_volumes.user_param u ON v.id = u.volume_id
WHERE u.name = 'cost_per_gb'
GROUP BY "volume name"
ORDER BY "Total Cost" DESC
LIMIT 20
