/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH selected_tags AS (
    SELECT tag,
           SUM(size) as physical_size_sum
    FROM sf_reports.tags_current
    WHERE SUBSTRING(tag, 1, length('__')) != '__'
    GROUP BY tag
    ORDER BY physical_size_sum DESC
    LIMIT 10
), query AS (
    SELECT
        tags_current.tag,
        mtime_age AS mtime,
        SUM(ROUND(size / (1024 * 1024 * 1024.0), 2)) AS "size logical (GiB)",
        SUM(ROUND(physical_size / (1024 * 1024 * 1024.0), 2)) AS "size physical (GiB)",
        SUM(count) AS count,
        SUM(cost) AS cost
    FROM sf_reports.tags_current AS tags_current
    INNER JOIN selected_tags ON selected_tags.tag = tags_current.tag
    WHERE (ROUND(size / (1024 * 1024 * 1024.0), 2) > 0)
    GROUP BY tags_current.tag, mtime_age
    ORDER BY mtime, SUM(size) DESC
), is_empty AS (
    SELECT
        CASE
            WHEN EXISTS (SELECT * FROM query LIMIT 1) THEN 0
            ELSE 1
        END AS val
) SELECT * FROM query
UNION ALL
SELECT
    NULL AS tag,
    NULL AS mtime,
    NULL AS "size logical (GiB)",
    NULL AS "size physical (GiB)",
    NULL AS count,
    NULL AS cost
FROM is_empty WHERE is_empty.val = 1;
