/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

 CREATE TEMPORARY TABLE resolved_gid ON COMMIT DROP AS (
    SELECT DISTINCT
        g.volume_id,
        v.name AS volume_name,
        g.gid
    FROM sf.gid_mapping g
    INNER JOIN sf_volumes.volume v ON v.id = g.volume_id
    WHERE
        g.name = '{{groupname}}' OR g.gid::TEXT = '{{groupname}}'
);
CREATE INDEX resolved_gid_idx ON resolved_gid (gid, volume_id);
ANALYZE resolved_gid;

SELECT
    volume,
    path,
    ROUND(size_GiB, 2) AS size_GiB
FROM (
    SELECT
        v.name AS volume,
        d.path,
        (d.local_aggrs->'total'->>'size')::BIGINT / (1024.0 * 1024 * 1024) AS size_GiB
    FROM sf.dir_current AS d
    INNER JOIN resolved_gid AS g ON d.gid = g.gid AND g.volume_id = d.volume_id
    INNER JOIN sf_volumes.volume AS v ON d.volume_id = v.id

    UNION ALL

    SELECT
        'All volumes' AS volume,
        'All files owned by group' AS path,
        SUM(size) / (1024.0 * 1024 * 1024) AS size_GiB
    FROM sf_reports.last_time_generic_current AS ltgc
    INNER JOIN resolved_gid g ON ltgc.gid = g.gid AND ltgc.volume_name = g.volume_name

    UNION ALL

    SELECT
        'All volumes' AS volume,
        'All dirs owned by group' AS path,
        SUM((d.local_aggrs->'total'->>'size')::BIGINT) / (1024.0 * 1024 * 1024) AS size_GiB
    FROM sf.dir_current d
    INNER JOIN resolved_gid g ON g.volume_id = d.volume_id AND g.gid = d.gid
) t
ORDER BY size_GiB DESC
LIMIT 1000
