/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH ajobs AS (
    SELECT
        aj.id,
        at.type AS target_type,
        v.name AS volume,
        aj.archive_target_name AS target,
        JSONB_ARRAY_ELEMENTS_TEXT(aj.low_level_jobs::JSONB->'UPLOADING_FILES')::BIGINT AS llj,
        EXTRACT(EPOCH FROM(aj.end_time - aj.creation_time)) AS elapsed_time,
        CASE WHEN aj.archiving_options->>'migrate' = 'false' THEN 'copy'
        ELSE 'migrate'
        END AS archive_type
    FROM sf_archive.archive_job aj
    INNER JOIN sf_archive.archive_target at ON aj.target_id = at.id
    INNER JOIN sf_volumes.volume v ON aj.volume_id = v.id
    WHERE aj.creation_time >= NOW() - INTERVAL '{{number_of_days_to_look_back}} day'
)
SELECT ajobs.archive_type,
       ajobs.target,
       ajobs.volume,
       ajobs.target_type,
       SUM(ajobs.elapsed_time) AS elapsed_seconds,
       ROUND(SUM((sji.fs_stats->>'fs_bytes_done')::BIGINT) / (1024::BIGINT * 1024 * 1024 * 1024),2) AS size_TiB,
       ROUND(SUM((sji.fs_stats->>'fs_bytes_done')::BIGINT) / (1000::BIGINT * 1000 * 1000 * 1000),2) AS size_TB,
       CASE
            WHEN SUM(ajobs.elapsed_time::BIGINT) != 0 THEN
            ROUND(SUM((sji.fs_stats->>'fs_bytes_done')::BIGINT) / (1000 * 1000) / SUM(ajobs.elapsed_time::BIGINT),2)
            ELSE 0.00
       END AS "MB/s",
       SUM((sji.fs_stats->>'fs_entries_done')::BIGINT)::BIGINT AS entries
FROM sf_dispatcher.incarnation sji
INNER JOIN ajobs ON ajobs.llj = sji.job_id
GROUP BY archive_type,
         target,
         target_type,
         volume
