/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH ajobs AS (
  SELECT aj.id,
         at.type AS target_type,
         JSONB_ARRAY_ELEMENTS_TEXT(aj.low_level_jobs::JSONB->'UPLOADING_FILES')::BIGINT AS llj
  FROM sf_archive.archive_job aj
  INNER JOIN sf_archive.archive_target at ON aj.target_id = at.id
    WHERE aj.creation_time >= NOW() - INTERVAL '{{number_of_days_to_look_back}} day'
),
totals AS (
 SELECT
       ajobs.target_type,
       sji.created_at::DATE AS run_date,
       COALESCE(ROUND(SUM((sji.fs_stats->>'fs_bytes_done')::NUMERIC)       /
            (1024::BIGINT * 1024*1024*1024),2), 0)
            AS size_TiB,
       COALESCE(ROUND(SUM((sji.fs_stats->>'fs_bytes_done')::NUMERIC) /
            (1000::BIGINT * 1000*1000*1000),2), 0) AS size_TB,
       SUM((sji.fs_stats->>'fs_entries_done')::BIGINT)::BIGINT AS entries
 FROM sf_dispatcher.incarnation sji
 INNER JOIN ajobs ON ajobs.llj = sji.job_id
 GROUP BY target_type, run_date
 ORDER BY target_type
)
SELECT -- archive_type,
       target_type,
       run_date,
       SUM(size_TB) OVER (ORDER BY run_date) AS size_TB,
       SUM(size_TiB) OVER (ORDER BY run_date) AS size_TiB,
       SUM(entries) OVER (ORDER BY run_date) AS entries
FROM totals
