/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH db_size AS (
    SELECT PG_DATABASE_SIZE(CURRENT_DATABASE()) AS database_size
)
SELECT
    n.nspname AS namespace,
    c.relname AS tablename,
    REGEXP_REPLACE(c.relname, '_part_[0-9]+$', '') AS parent_table,
    SUM(PG_TOTAL_RELATION_SIZE(c.oid)) as total_relation_size,
    SUM(PG_TABLE_SIZE(c.oid)) as data_size,
    SUM(pg_stat_get_live_tuples(c.oid))::BIGINT AS n_live_tup,
    SUM(pg_stat_get_dead_tuples(c.oid))::BIGINT AS n_dead_tup,
    MAX(db.database_size) as database_size
FROM pg_class c
LEFT JOIN pg_namespace n ON n.oid = c.relnamespace
CROSS JOIN db_size as db
WHERE (n.nspname LIKE 'sf%' AND n.nspname != 'sf_internal') AND c.relkind = ANY (ARRAY['r'::"char", 'm'::"char", 'p'::"char"])
GROUP BY namespace, tablename
