/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
WITH const AS (
    SELECT 10 * 1000 * 1000 AS min_file_size
),
duplicates_estimate AS (
    SELECT  COALESCE(SUM(count - 1) FILTER(WHERE size >= const.min_file_size), 0) AS duplicates_count,
            COALESCE(SUM(count), 0) AS total_count,
            COALESCE(SUM((count - 1) * size) FILTER(WHERE size >= const.min_file_size), 0) AS duplicates_size,
            COALESCE(SUM(count * size), 0) AS total_size
        FROM (
            SELECT size / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END AS size,
                   count(*) AS count
                FROM sf.file_current AS f
                GROUP BY 1
        ) AS t, const
) SELECT duplicates_count AS "DUPLICATES COUNT",
         total_count AS "TOTAL COUNT",
         CASE WHEN total_count = 0 THEN 0
              ELSE ROUND(duplicates_count * 100 / total_count, 1)
         END AS "DUPLICATES COUNT PERCENTAGE",
         duplicates_size AS "DUPLICATES SIZE",
         total_size AS "TOTAL SIZE",
         CASE WHEN total_size = 0 THEN 0
              ELSE ROUND(duplicates_size * 100 / total_size, 1)
         END AS "DUPLICATES SIZE PERCENTAGE",
         const.min_file_size AS "MIN FILE SIZE"
    FROM duplicates_estimate, const;
