/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
WITH log_raw_result AS (
    SELECT dir.volume_id,
           SUM((dir.local_aggrs->'total'->>'size')::BIGINT) AS logical_size,
           SUM((dir.local_aggrs->'total'->>'blocks')::BIGINT * 512) AS physical_size,
           COUNT(*) AS count,
           CASE
             WHEN (dir.local_aggrs->'total'->>'blocks')::BIGINT >= 1 THEN ceil(log((dir.local_aggrs->'total'->>'blocks')::BIGINT * 512))::SMALLINT
             WHEN (dir.local_aggrs->'total'->>'blocks')::BIGINT = 0 THEN 0::SMALLINT
           END AS log_size
    FROM sf.dir_current AS dir
    WHERE dir.local_aggrs IS NOT NULL
    GROUP BY log_size, dir.volume_id
), min_max_sizes AS (
    WITH recursive sizes(log_size, min_size, max_size) AS (
        VALUES (CAST(1 AS SMALLINT), CAST(1 AS BIGINT), CAST(10 AS BIGINT))
        UNION ALL
        SELECT CAST(log_size + 1 AS SMALLINT), CAST(max_size + 1 AS BIGINT), CAST(10 * max_size AS BIGINT)
            FROM sizes
            WHERE max_size <= CAST(576460752303423488 AS BIGINT)
    )
    SELECT *
        FROM sizes
        UNION SELECT 0, 0, 0
        ORDER BY min_size
), sizes AS (
    SELECT *,
           CASE
               WHEN max_size = 0 THEN '0B'
               WHEN max_size = 10 THEN '1B ... 10B'
               WHEN max_size = 100 THEN '10B ... 100B'
               WHEN max_size = 1000 THEN '100B ... 1KB'
               WHEN max_size = 10000 THEN '1KB ... 10KB'
               WHEN max_size = 100000 THEN '10KB ... 100KB'
               WHEN max_size = 1000000 THEN '100KB ... 1MB'
               WHEN max_size = 10000000 THEN '1MB ... 10MB'
               WHEN max_size = 100000000 THEN '10MB ... 100MB'
               WHEN max_size = 1000000000 THEN '100MB ... 1GB'
               WHEN max_size = 10000000000 THEN '1GB ... 10GB'
               WHEN max_size = 100000000000 THEN '10GB ... 100GB'
               WHEN max_size = 1000000000000 THEN '100GB ... 1TB'
               WHEN max_size = 10000000000000 THEN '1TB ... 10TB'
               WHEN max_size = 100000000000000 THEN '10TB ... 100TB'
               WHEN max_size = 1000000000000000 THEN '100TB ... 1PB'
               WHEN max_size = 10000000000000000 THEN '1PB ... 10PB'
               WHEN max_size = 100000000000000000 THEN '10PB ... 100PB'
               WHEN max_size = 1000000000000000000 THEN '100PB ... 1EB'
           END AS friendly_name
    FROM min_max_sizes
)
SELECT v.name AS volume_name,
       s.min_size,
       s.max_size,
       s.friendly_name,
       r.logical_size AS total_size, -- total_size name is backward compatibility
       r.physical_size AS physical_size,
       CASE
            WHEN COALESCE(v.total_capacity, 0) > 0 THEN ROUND(r.physical_size * 100 / v.total_capacity, 1)
            ELSE NULL
       END AS percent_of_whole_volume,
       r.count
FROM log_raw_result r
    JOIN sizes s ON r.log_size = s.log_size
    JOIN sf_volumes.volume v ON r.volume_id=v.id
ORDER BY v.id, min_size
