#!/bin/bash
#***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
#***********************************************************************************************************

# This script is run on new version of package in case of upgrade
# This script is run only for DEB.
# For RPM package see "pre-trans.sh"

set -euo pipefail

PREFIX="${RPM_INSTALL_PREFIX:-}"
PACKAGE_NAME="sf-redash"
SFHOME="${PREFIX}${SFHOME:-/opt/starfish}"

set_env() {
    if [[ "${PREFIX}" == / ]]; then
        PREFIX=""
    fi
    export SFHOME=${PREFIX}${SFHOME:-/opt/starfish}
}

set_env

# This script is run for all packages (starfish, sf-agent, sf-client etc)
# so the directory can be already renamed.
if [[ "${PACKAGE_NAME}" == "starfish" || "${PACKAGE_NAME}" == "sf-agent" || "${PACKAGE_NAME}" == "sf-client" ]]; then
    if [[ ! -L "${SFHOME}/bin/examples" && -d "${SFHOME}/bin/examples" ]]; then
        echo "[${PACKAGE_NAME}] Moving ${SFHOME}/bin/examples to ${SFHOME}/bin/examples-backup"
        mv "${SFHOME}/bin/examples" "${SFHOME}/bin/examples-backup"
    fi
fi

is_db_non_partitioned() {
    local runquery_path="${SFHOME}/bin/tools/runquery"

    if [ ! -f "${runquery_path}" ]; then
        echo '[db partitioned check] runquery script not found, assuming new server installation.'
        return 1
    fi

    partitioned_sql=" \
    SELECT CASE WHEN relkind = 'p' THEN 'YES' ELSE 'NO' END \
    FROM pg_catalog.pg_class \
    WHERE relname = 'dir_current' AND relnamespace::regnamespace::TEXT = 'sf'"
    partitioned="$("${runquery_path}" --tuples-only --no-align -c "${partitioned_sql}")"
    echo "[db partitioned check] partitioned=${partitioned}"
    if [ -z "${partitioned}" ]; then
        echo "[db partitioned check] DB is probably empty, will be partitioned by default."
    fi

    if [[ "${partitioned}" == NO ]]; then
        return 0
    fi

    return 1
}

if [[ "${PACKAGE_NAME}" == starfish ]]; then
    if is_db_non_partitioned; then
        echo "Non-partitioned DB is no longer supported."
        echo "Upgrading to the newest version of Starfish is disabled if database"
        echo "is not partitioned. Please contact support in order to partition your database"
        echo "and then try upgrading again."
        exit 1
    fi
fi
