"""
***********************************************************************************************************

 Starfish Storage Corporation ("Starfish") CONFIDENTIAL
 Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.

 NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
 Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
 intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
 U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
 Dissemination of this information or reproduction of this material is strictly forbidden unless prior
 written permission is obtained from Starfish. Access to the source code contained herein is hereby
 forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
 confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
 Starfish's software.

 ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
 THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
 AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
 FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
 DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
 WHOLE OR IN PART.

 FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
   These notices shall be marked on any reproduction of this data, in whole or in part.
   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
   Software clause at DFARS 52.227-7013.

***********************************************************************************************************
Version 1.0      2019-10-24     Doug
Initialize hashes on every file path

"""

import hashlib
import os
import unittest

# set a 10MB  buffer size for hash computation
BUFFER_SIZE = 1024 * 1024 * 10


class Hasher:
    """object for computing hashes in user space"""

    def __init__(self, **kwargs):
        self.md5 = None
        self.sha1 = None
        if "debug" in kwargs:
            self.debug = kwargs["debug"]
        else:
            self.debug = 0

    def gethashes(self, fname):
        """get hashes on a file by name
        :returns: dict of md5 and sha1"""
        # init for each file
        self.md5 = hashlib.md5()
        self.sha1 = hashlib.sha1()
        if not os.path.exists(fname):
            return None
        try:
            with open(fname, "rb") as fh:
                while True:
                    chunk = fh.read(BUFFER_SIZE)
                    if not chunk:
                        break
                    self.md5.update(chunk)
                    self.sha1.update(chunk)
                    if self.debug > 1:
                        print("hashed bytes:" + str(len(chunk)))
            return {"md5": self.md5.hexdigest(), "sha1": self.sha1.hexdigest()}
        except OSError as e:
            print("opening file: " + (str(e)))
            return None


class TestHash(unittest.TestCase):
    """extension for unittest framework"""

    def setUp(self):
        pass

    def testhashes(self):
        """run a simple unit test to confirm functionality"""

        with open("/tmp/.h1test", "w") as wh:
            wh.write("hi there")

        h = Hasher()
        h2 = h.gethashes("/tmp/.h1test")

        self.assertEqual(
            h2, {"md5": "fd33e2e8ad3cb1bdd3ea8f5633fcf5c7", "sha1": "56170f5429b35dea081bb659b884b475ca9329a9"}
        )
