#!/opt/starfish/examples/venv/bin/python3
# ***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
# ***********************************************************************************************************

import argparse
import os
import sys

if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description="bulk change ownership and optionally group of files."
        "all files come from starfish dispatcher on stdin with Null separator."
        "Help in change of ownership of all entries."
        "Example job start command"
        "sf job start --paths-via-stdin"
        "'/opt/starfish/examples/examples/src/sfexamples/job/batch_chowner.py --uid 1000 --gid 1000' volume:PATH"
    )

    parser.add_argument("--debug", "-d", required=False, type=int, default=0, help="Show instead of do")
    parser.add_argument("--uid", "-u", required=True, help="The numeric uid to use")
    parser.add_argument("--gid", "-g", required=False, help="The numeric gid to use")
    args = parser.parse_args()

    for path in sys.stdin.read().split("\0"):
        if args.debug > 0:
            if args.gid:
                print(f"chown {args.uid} {args.gid} {path}", file=sys.stderr)
            else:
                print(f"chown {args.uid} {path}", file=sys.stderr)
        else:
            try:
                if not path:
                    continue
                orig_gid = os.stat(path).st_gid
                new_gid = int(args.gid) if args.gid else orig_gid
                new_uid = int(args.uid)
                os.chown(path, new_uid, new_gid, follow_symlinks=False)
                print(f"{path}\0SUCCESS chown uid={new_uid} gid={new_gid}", end="\0")
            except OSError as e:
                print(f"Error changing ownership of {path}: {str(e)}", file=sys.stderr)
    sys.exit(0)
