/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

CREATE TABLE sf_auth.membership (
  id bigserial NOT NULL PRIMARY KEY
);

CREATE TABLE sf_auth.user_membership (
  user_id bigint NOT NULL REFERENCES sf_auth.user(id),
  membership_id bigint NOT NULL REFERENCES sf_auth.membership(id) ON DELETE CASCADE,
  PRIMARY KEY (user_id, membership_id)
);

CREATE TABLE sf_auth.group_membership (
  group_id bigint NOT NULL REFERENCES sf_auth.group(id),
  membership_id bigint NOT NULL REFERENCES sf_auth.membership(id) ON DELETE CASCADE,
  PRIMARY KEY (group_id, membership_id)
);

CREATE TABLE sf_auth.system_role (
  id bigserial NOT NULL PRIMARY KEY,
  name text NOT NULL UNIQUE,
  description text,
  membership_id bigint REFERENCES sf_auth.membership(id),
  is_available_to_all_users bool NOT NULL,
  created_by_id bigint NOT NULL REFERENCES sf_auth.user(id)
  CONSTRAINT no_membership_id_if_available_to_all_users CHECK (is_available_to_all_users = (membership_id IS NULL))

);

CREATE TABLE sf_auth.zone_v2 (
  id bigserial PRIMARY KEY,
  name text NOT NULL UNIQUE,
  admin_membership_id bigint NOT NULL REFERENCES sf_auth.membership(id),
  user_membership_id bigint NOT NULL REFERENCES sf_auth.membership(id),
  description text,
  created_by_id bigint NOT NULL REFERENCES sf_auth.user(id)
);

CREATE TABLE sf_auth.zone_user_param_v2 (
  zone_id bigint NOT NULL REFERENCES sf_auth.zone_v2(id) ON DELETE CASCADE,
  name varchar NOT NULL,
  value varchar NOT NULL,
  PRIMARY KEY (zone_id, name)
);

CREATE TABLE sf_auth.capability (
  id bigserial PRIMARY KEY,
  name text NOT NULL UNIQUE
);

CREATE TABLE sf_auth.system_role_capability (
  system_role_id bigint NOT NULL REFERENCES sf_auth.system_role(id) ON DELETE CASCADE,
  capability_id bigint NOT NULL REFERENCES sf_auth.capability(id),
  PRIMARY KEY (system_role_id, capability_id)
);

CREATE TABLE sf_auth.zone_v2_capability (
  id bigserial PRIMARY KEY,
  zone_id bigint NOT NULL REFERENCES sf_auth.zone_v2(id) ON DELETE CASCADE,
  capability_id bigint NOT NULL REFERENCES sf_auth.capability(id),
  is_delegable bool NOT NULL,
  CONSTRAINT capability_at_most_once_in_zone UNIQUE (zone_id, capability_id)
);

CREATE TABLE sf_auth.default_zone_role (
  id bigserial PRIMARY KEY,
  name text NOT NULL UNIQUE,
  description text,
  is_available_in_all_zones bool NOT NULL,
  created_by_id bigint NOT NULL REFERENCES sf_auth.user(id)
);

CREATE TABLE sf_auth.default_zone_role_capability (
  default_zone_role_id bigint NOT NULL REFERENCES sf_auth.default_zone_role(id) ON DELETE CASCADE,
  capability_id bigint NOT NULL REFERENCES sf_auth.capability(id),
  PRIMARY KEY (default_zone_role_id, capability_id)
);

CREATE TABLE sf_auth.default_zone_role_zone_v2 (
  default_zone_role_id bigint NOT NULL REFERENCES sf_auth.default_zone_role(id),
  zone_id bigint NOT NULL REFERENCES sf_auth.zone_v2(id) ON DELETE CASCADE,
  PRIMARY KEY (default_zone_role_id, zone_id)
);

CREATE TABLE sf_auth.custom_zone_role (
  id bigserial PRIMARY KEY,
  name text NOT NULL,
  zone_id bigint NOT NULL REFERENCES sf_auth.zone_v2(id) ON DELETE CASCADE,
  membership_id bigint REFERENCES sf_auth.membership(id),
  is_available_to_all_zone_users bool NOT NULL,
  description text,
  created_by_id bigint NOT NULL REFERENCES sf_auth.user(id),
  CONSTRAINT no_membership_id_if_available_to_all_users CHECK (is_available_to_all_zone_users = (membership_id IS NULL)),
  CONSTRAINT names_of_custom_zone_roles_are_unique_within_zone UNIQUE (zone_id, name)
);

CREATE TABLE sf_auth.custom_zone_role_capability (
  id bigserial PRIMARY KEY,
  custom_zone_role_id bigint NOT NULL REFERENCES sf_auth.custom_zone_role(id) ON DELETE CASCADE,
  zone_capability_id bigint NOT NULL REFERENCES sf_auth.zone_v2_capability(id) ON DELETE CASCADE,
  is_available_for_all_zone_resources bool NOT NULL,
  CONSTRAINT capability_at_most_once_in_custom_zone_role UNIQUE (custom_zone_role_id, zone_capability_id)
);

CREATE TABLE sf_auth.resource_type (
    id bigserial PRIMARY KEY,
    name varchar NOT NULL UNIQUE
);

CREATE TABLE sf_auth.resource (  -- base table for all resources (e.g. sf.tag_namespace.id)
  unique_id bigserial PRIMARY KEY, -- for auth usage
  type_id bigint NOT NULL REFERENCES sf_auth.resource_type(id),
  id bigint NOT NULL,  -- e.g. sf.tag_namespace.id
  admin_membership_id bigint NOT NULL REFERENCES sf_auth.membership(id),
  is_available_in_all_zones bool NOT NULL,
  created_by_id bigint NOT NULL REFERENCES sf_auth.user(id),
  description text,
  CONSTRAINT resource_id_is_unique_within_resource_type UNIQUE (type_id, id)  -- auth needs global id and uses unique_id
);

CREATE TABLE sf_auth.resource_in_zone_v2 (
  resource_unique_id bigint NOT NULL REFERENCES sf_auth.resource(unique_id) ON DELETE CASCADE,
  zone_id bigint NOT NULL REFERENCES sf_auth.zone_v2(id) ON DELETE CASCADE,
  PRIMARY KEY (resource_unique_id, zone_id)
);

CREATE TABLE sf_auth.custom_zone_role_capability_resource (
  custom_zone_role_capability_id bigint NOT NULL REFERENCES sf_auth.custom_zone_role_capability(id) ON DELETE CASCADE,
  -- not resource_in_zone because if resource.is_available_in_all_zones = true, it's not in resource_in_zone
  resource_unique_id bigint NOT NULL REFERENCES sf_auth.resource(unique_id) ON DELETE CASCADE,
  PRIMARY KEY (resource_unique_id, custom_zone_role_capability_id)
);
