/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */


CREATE OR REPLACE FUNCTION __get_tablespace(full_tablename VARCHAR)
RETURNS VARCHAR AS  -- returns NULL if the table is in default tablespace or it does not exist
$$
DECLARE
    result VARCHAR;
BEGIN
    SELECT tablespace
      INTO result
      FROM pg_tables
     WHERE (schemaname || '.' || tablename) = full_tablename;

    RETURN result;
END;
$$ LANGUAGE plpgsql STRICT IMMUTABLE PARALLEL SAFE;


CREATE OR REPLACE FUNCTION __move_to_same_custom_tablespace(table_to_move VARCHAR, reference_table VARCHAR)
RETURNS VOID AS
$$
DECLARE
    tblspc VARCHAR;
BEGIN
    SELECT __get_tablespace(reference_table) INTO tblspc;
    IF tblspc IS NOT NULL THEN
        EXECUTE 'ALTER TABLE ' || table_to_move || ' SET TABLESPACE ' || quote_ident(tblspc);
    END IF;
END;
$$ LANGUAGE plpgsql STRICT VOLATILE PARALLEL UNSAFE;

ALTER TABLE sf.refresh_aggregates RENAME TO refresh_aggregates_old;

CREATE TABLE sf.refresh_aggregates(
    id bigint,
    depth bigint,
    volume_id bigint NOT NULL
) PARTITION BY HASH (volume_id partition_custom_bigint_hash_op);
