/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
CREATE sequence sf_dispatcher.job_id_seq start WITH 1;

ALTER TABLE sf_dispatcher.incarnation DROP CONSTRAINT incarnation_pkey;
ALTER TABLE sf_dispatcher.incarnation DROP CONSTRAINT incarnation_job_id_fk;
ALTER TABLE sf_dispatcher.job DROP CONSTRAINT job_pkey;

ALTER TABLE sf_dispatcher.incarnation RENAME COLUMN job_id TO job_long_id;
ALTER TABLE sf_dispatcher.job RENAME COLUMN id TO long_id;
CREATE UNIQUE INDEX job_long_id ON sf_dispatcher.job(long_id);

ALTER TABLE sf_dispatcher.job ADD COLUMN id BIGINT PRIMARY KEY NOT NULL DEFAULT nextval('sf_dispatcher.job_id_seq');
ALTER TABLE sf_dispatcher.incarnation ADD COLUMN job_id BIGINT;

UPDATE sf_dispatcher.incarnation SET job_id = (SELECT id FROM sf_dispatcher.job AS job WHERE job.long_id = job_long_id);

ALTER TABLE sf_dispatcher.incarnation ADD CONSTRAINT incarnation_pkey PRIMARY KEY (job_id, incarnation_id);
ALTER TABLE sf_dispatcher.incarnation ADD CONSTRAINT incarnation_job_id_fk FOREIGN KEY (job_id)
      REFERENCES sf_dispatcher.job (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE;

ALTER TABLE sf_dispatcher.incarnation DROP COLUMN job_long_id;
ALTER TABLE sf_dispatcher.job DROP COLUMN long_id;
