/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
-- similar to:
 -- tags_redash_query.sql
 -- tags_in_zone_redash_query.sql
-- whenever someone changes this file changing the ones above should also be considered

SELECT
    COALESCE(volume.display_name, zone_namespace_tags_current.volume_name) AS volume_name,
    zone,
    namespace AS "tagset",
    tag,
    atime_age,
    mtime_age,
    ROUND(size / (1024 * 1024 * 1024.0), 2) AS "logical size (GiB)",
    ROUND(physical_size / (1024 * 1024 * 1024.0), 2) AS "physical size (GiB)",
    count,
    cost
FROM sf_reports.zone_namespace_tags_current as zone_namespace_tags_current
    LEFT JOIN sf_volumes.volume ON zone_namespace_tags_current.volume_name = sf_volumes.volume.name
