/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
-- similar to:
 -- tag_drilldown_redash_query.sql
 -- tag_in_zone_drilldown_redash_query.sql
 -- zone_tag_drilldown_redash_query.sql
-- whenever someone changes this file changing the ones above should also be considered

SELECT '<a href="DASHBOARD_LINK(zone-detail-analytics)?p_zone='||urlencode(z.name)||'">'||urlencode(z.name)||'</a>' AS "zone",
       SUM(size) / (1024 * 1024 * 1024.0) AS "logical size (GiB)",
       SUM(physical_size) / (1024 * 1024 * 1024.0) AS "physical size (GiB)",
       SUM(count)::BIGINT AS "count",
       MAX(run_time)::TIMESTAMP AS "update time"  -- we cast it to timestamp to cut off timezone info
       -- otherwise redash is showing invalid time (looks like bug in redash)
FROM sf_reports.tags_current AS t
JOIN sf_auth.zone AS z ON SUBSTRING(t.tag, length('__zone:')+1) = z.id::VARCHAR
WHERE SUBSTRING(t.tag, 1, length('__zone:')) = '__zone:'
GROUP BY z.name
ORDER BY z.name;
