/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
-- similar to:
 -- tag_details_drilldown_redash_query.sql
 -- zone_tag_details_drilldown_redash_query.sql
-- whenever someone changes this file changing the ones above should also be considered

SELECT '<a href="queries/QUERY_ID_FOR_REPORT(top_directories_within_zone)?p_zone='||zone.name||'">' ||zone.name|| '</a>' AS "zone",
       COALESCE(volume.display_name, tags_current.volume_name) AS volume,
       SUM(size) / (1024 * 1024 * 1024.0) AS "logical size (GiB)",
       SUM(physical_size) / (1024 * 1024 * 1024.0) AS "physical size (GiB)",
       SUM(count)::BIGINT AS "count",
       TRUNC(SUM(cost)::NUMERIC, 2) AS "cost",
       MAX(run_time) AS "update time"
FROM sf_reports.tags_current AS tags_current
    LEFT JOIN sf_volumes.volume ON tags_current.volume_name = volume.name
    JOIN sf_auth.zone ON SUBSTRING(tags_current.tag, length('__zone:')+1) = zone.id::VARCHAR
WHERE zone.name = '{{{zone}}}'
  AND SUBSTRING(tags_current.tag, 1, length('__zone:')) = '__zone:'
GROUP BY zone.name, volume
ORDER BY zone.name, volume
