/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */


WITH expanded AS (
    SELECT
           v.name || ':' || dh.path AS volpath,
           generate_series(date_trunc('day',GREATEST(lower(dh.valid), now() - INTERVAL '{{days_to_look_back}} days')),
                           date_trunc('day',LEAST(upper(dh.valid), now())), interval '1 day') AS date,
           AVG(((dh.rec_aggrs->>'size')::NUMERIC) / (1024.0 * 1024 * 1024)) AS size_GiB,
           AVG((dh.rec_aggrs->>'files')::BIGINT) AS files
    FROM sf.tag_value_current tvc
    INNER JOIN sf.tag_name tn ON tvc.name_id = tn.id
    INNER JOIN sf.tag_namespace SPACE ON tn.namespace_id = space.id
    INNER JOIN sf_volumes.volume v ON v.id = tvc.volume_id
    JOIN sf_auth.zone zname ON tn.name = zname.id::varchar
    INNER JOIN sf.dir dh ON dh.id = tvc.fs_entry_id AND dh.volume_id = tvc.volume_id
    WHERE space.name = '__zone'
      AND zname.name = '{{zone}}'
      AND UPPER(dh.valid) > now() - INTERVAL '{{days_to_look_back}} days'
    GROUP BY volpath, date
)
SELECT
    volpath,
    date,
    ROUND(size_GiB, 1) AS size_GiB,
    ROUND(files, 1) AS files
FROM expanded

UNION ALL

SELECT
    'SUM' AS volpath,
    date,
    ROUND(SUM(size_GiB), 1) AS size_GiB,
    ROUND(SUM(files), 1) AS files
FROM expanded
GROUP BY date
ORDER BY volpath, date
