/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
-- similar to:
 -- tag_aging_redash_query.sql
 -- zone_tag_aging_redash_query.sql
-- whenever someone changes this file changing the ones above should also be considered

WITH tag_aging_per_volume AS (
    SELECT COALESCE(volume.display_name, tags_current.volume_name) AS volume,
           atime_age,
           mtime_age,
           ROUND(SUM(size) / (1024 * 1024 * 1024.0), 2) AS "logical size (GiB)",
           ROUND(SUM(physical_size) / (1024 * 1024 * 1024.0), 2) AS "physical size (GiB)",
           SUM(count) AS count,
           SUM(cost) AS cost,
           run_time
    FROM sf_reports.tags_current
        LEFT JOIN sf_volumes.volume ON tags_current.volume_name = volume.name
        JOIN sf_auth.zone ON SUBSTRING(tags_current.tag, length('__zone:')+1) = zone.id::VARCHAR
    WHERE zone.name = '{{{zone}}}'
      AND SUBSTRING(tags_current.tag, 1, length('__zone:')) = '__zone:'
    GROUP BY volume,
             atime_age,
             mtime_age,
             run_time
    ORDER BY volume,
             atime_age,
             mtime_age
) SELECT tag_aging_per_volume.*,
         SUM("logical size (GiB)") OVER (PARTITION BY atime_age) as logical_size_GiB_sum_for_all_vols,
         SUM("physical size (GiB)") OVER (PARTITION BY atime_age) as physical_size_GiB_sum_for_all_vols,
         SUM(Count) OVER (PARTITION BY atime_age) as count_sum_for_all_vols,
         SUM(Cost) OVER (PARTITION BY atime_age) as cost_sum_for_all_vols
    FROM tag_aging_per_volume
