/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
WITH churn_raw AS (
    SELECT
        volume.name AS volume_name,
        -- line below is: convert scan.heartbeat to epoch (seconds since 1970), round to X days, convert back to date
        to_timestamp(ROUND(EXTRACT(EPOCH FROM scan.heartbeat) / (3600 * 24 * {{group_by_days}})) * (3600 * 24 * {{group_by_days}}) )::date AS date,
        COALESCE(SUM((stats#>>'{processing_stats,ADDED_DIR_COUNT}')::BIGINT), 0) AS added_dir_count,
        COALESCE(SUM((stats#>>'{processing_stats,ADDED_FILE_COUNT}')::BIGINT), 0) AS added_file_count,
        COALESCE(SUM((stats#>>'{processing_stats,REMOVED_DIR_COUNT}')::BIGINT), 0) AS removed_dir_count,
        COALESCE(SUM((stats#>>'{processing_stats,REMOVED_FILE_COUNT}')::BIGINT), 0) AS removed_file_count,
        COALESCE(SUM((stats#>>'{processing_stats,CHANGED_DIR_COUNT}')::BIGINT), 0) AS changed_dir_count,
        COALESCE(SUM((stats#>>'{processing_stats,CHANGED_FILE_COUNT}')::BIGINT), 0) AS changed_file_count,
        COALESCE(SUM((stats#>>'{processing_stats,ADDED_DIR_SIZE}')::BIGINT), 0) AS added_dir_size,
        COALESCE(SUM((stats#>>'{processing_stats,ADDED_FILE_SIZE}')::BIGINT), 0) AS added_file_size,
        COALESCE(SUM((stats#>>'{processing_stats,REMOVED_DIR_SIZE}')::BIGINT), 0) AS removed_dir_size,
        COALESCE(SUM((stats#>>'{processing_stats,REMOVED_FILE_SIZE}')::BIGINT), 0) AS removed_file_size,
        COALESCE(SUM((stats#>>'{processing_stats,CHANGED_DIR_SIZE}')::BIGINT), 0) AS changed_dir_size_delta,
        COALESCE(SUM((stats#>>'{processing_stats,CHANGED_FILE_SIZE}')::BIGINT), 0) AS changed_file_size_delta
    FROM sf_scans.scan
    LEFT JOIN sf_scans.loader_info ON loader_info.scan_id = scan.id
    LEFT JOIN sf_volumes.volume ON scan.volume_id = volume.id
    WHERE scan.state_name = 'done'
        AND scan.volume_id = sf.volume_id_from_name('{{volume}}')
        AND scan.heartbeat >= now() - interval '{{number_of_days_to_look_back}} days'
    GROUP BY volume.name, date
    ORDER BY volume.name, date DESC
)
SELECT
    date,
    added_dir_count + added_file_count AS "added files",
    removed_dir_count + removed_file_count AS "removed files",
    (- removed_dir_count - removed_file_count) AS "removed files negative",
    changed_dir_count + changed_file_count AS "changed files",
    ROUND((added_dir_size + added_file_size) / (1024 * 1024 * 1024.0), 2) AS "added files size (GiB)",
    ROUND((removed_dir_size + removed_file_size) / (1024 * 1024 * 1024.0), 2) AS "removed files size (GiB)",
    ROUND((- removed_dir_size - removed_file_size) / (1024 * 1024 * 1024.0), 2) AS "removed files size negative (GiB)",
    ROUND((changed_dir_size_delta + changed_file_size_delta) / (1024 * 1024 * 1024.0), 2) AS "changed files size delta (GiB)"
FROM churn_raw
