/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
WITH query AS (
    SELECT
        COALESCE(volume.display_name, last_time_generic_current.volume_name) AS volume,
        user_name as user,
        group_name as group,
        uid,
        gid,
        atime_age as atime,
        mtime_age as mtime,
        ROUND(size / (1024 * 1024 * 1024.0), 2) AS "size logical (GiB)",
        ROUND(physical_size / (1024 * 1024 * 1024.0), 2) AS "size physical (GiB)",
        count,
        cost
    FROM sf_reports.last_time_generic_current
        LEFT JOIN sf_volumes.volume ON last_time_generic_current.volume_name = volume.name
    WHERE user_total_size >= {{min_size_per_user_GB}}::BIGINT * 1024 * 1024 * 1024
        AND (ROUND(size / (1024 * 1024 * 1024.0), 2) > 0)
), is_empty AS (
    SELECT
        CASE
            WHEN EXISTS (SELECT * FROM query LIMIT 1) THEN 0
            ELSE 1
        END AS val
) SELECT * FROM query
UNION ALL
SELECT
    'No results. Decrease Min size per user (GiB) and refresh the report' AS volume,
    NULL AS user,
    NULL AS group,
    NULL AS uid,
    NULL AS gid,
    NULL AS atime,
    NULL AS mtime,
    NULL AS "size logical (GiB)",
    NULL AS "size physical (GiB)",
    NULL AS count,
    NULL AS cost
FROM is_empty WHERE is_empty.val = 1;
