/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
WITH user_aging_per_volume AS (
    SELECT COALESCE(volume.display_name, last_time_generic_current.volume_name) AS volume_name,
           atime_Age,
           mtime_age,
           ROUND(SUM(size) / (1024 * 1024 * 1024.0), 2) AS "logical size (GiB)",
           ROUND(SUM(physical_size) / (1024 * 1024 * 1024.0), 2) AS "physical size (GiB)",
           SUM(count) AS Count,
           SUM(cost) AS Cost
    FROM sf_reports.last_time_generic_current
        LEFT JOIN sf_volumes.volume ON last_time_generic_current.volume_name = sf_volumes.volume.name
    WHERE user_name = '{{username}}'
    GROUP BY COALESCE(volume.display_name, last_time_generic_current.volume_name),
             atime_age,
             mtime_age
) SELECT user_aging_per_volume.*,
         SUM("logical size (GiB)") OVER (PARTITION BY atime_age) AS "Sum of logical size for all volumes (GiB)",
         SUM("physical size (GiB)") OVER (PARTITION BY atime_age) AS "Sum of physical size for all volumes (GiB)",
         SUM(Count) OVER (PARTITION BY atime_age) AS "Sum of files for all volumes",
         ROUND((SUM(Cost) OVER (PARTITION BY atime_age))::NUMERIC, 2) AS "Summed cost for all volumes"
    FROM user_aging_per_volume
    ORDER BY "physical size (GiB)"
