/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT COALESCE(v.display_name, v.name) AS "volume",
       '/' || path AS "path",
       ROUND((dir.rec_aggrs->>'size')::DECIMAL / (1024 * 1024 * 1024.0), 2) AS "logical size (GiB)",
       ROUND((COALESCE(rec_aggrs->>'blocks_div_nlinks', rec_aggrs->>'blocks')::BIGINT * 512)::DECIMAL / (1024 * 1024 * 1024.0), 2) AS "physical size (GiB)",
       (dir.rec_aggrs->>'files')::BIGINT as "file count",
       (dir.rec_aggrs->>'dirs')::BIGINT as "subdirectory count"
FROM sf.dir_current AS dir
INNER JOIN sf_volumes.volume AS v ON dir.volume_id = v.id
LEFT JOIN sf.uid_mapping AS uidm ON uidm.volume_id = v.id AND uidm.uid = dir.uid
WHERE (uidm.name = '{{username}}' OR dir.uid::TEXT = '{{username}}')
AND dir.depth <= {{max_depth}}
ORDER BY "logical size (GiB)" DESC
LIMIT {{number_of_rows}}
