/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
-- similar to:
 -- zone_drilldown_redash_query.sql
 -- tag_in_zone_drilldown_redash_query.sql
 -- zone_tag_drilldown_redash_query.sql
-- whenever someone changes this file changing the ones above should also be considered

SELECT '<a href="DASHBOARD_LINK(tag-detail-analytics)?p_tag='||urlencode(tag)||'">'||urlencode(tag)||'</a>' AS "tag",
       SUM(size) / (1024 * 1024 * 1024.0) AS "logical size (GiB)",
       SUM(physical_size) / (1024 * 1024 * 1024.0) AS "physical size (GiB)",
       SUM(count)::BIGINT AS "count",
       MAX(run_time)::TIMESTAMP AS "update time"  -- we cast it to timestamp to cut off timezone info
       -- otherwise redash is showing invalid time (looks like bug in redash)
FROM sf_reports.tags_current
WHERE SUBSTRING(tag, 1, length('__')) != '__'
GROUP BY tag
ORDER BY tag;
