/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
SELECT COALESCE(volume.display_name, dir_nonrecursive_size_current.volume_name) AS volume_name,
       min_size,
       max_size,
       friendly_name,
       total_size,
       physical_size,
       percent_of_whole_volume,
       count,
       ROUND(COALESCE(physical_size, total_size) / (1024 * 1024 * 1024.0), 2) AS size_gib_for_chart
FROM sf_reports.dir_nonrecursive_size_current
    LEFT JOIN sf_volumes.volume ON dir_nonrecursive_size_current.volume_name = volume.name
ORDER BY min_size
