/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT
    volume_name AS "Volume Name",
    SUM(count)::BIGINT as "Number of Files",
    ROUND(SUM(size)  / (1024 * 1024 * 1024.0), 2) AS "Size of Data (GiB)"
FROM sf_reports.last_time_generic_current
WHERE mtime_age = 'future'
GROUP BY volume_name
ORDER BY SUM(count) DESC
LIMIT 20
